/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.persistence.factories;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.user.persistence.UserSubscriptionStore;
import net.bluemind.user.repository.IUserSubscriptionStore;

public class UserSubscriptionStoreFactory implements IContainerBoundFactory<IUserSubscriptionStore> {

	@Override
	public Class<IUserSubscriptionStore> factoryClass() {
		return IUserSubscriptionStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IUserSubscriptionStore instance(BmContext context, Container container) throws ServerFault {
		return new UserSubscriptionStore(context, context.getDataSource(), container);
	}

}
