import { MailboxItem, MessageBody } from "@bluemind/backend.mail.api";
import { ItemValue } from "@bluemind/core.container.api";
import { constants, enums, exceptions, helper } from "@bluemind/smime.commons";

import pkcs7 from "../pkcs7";

import saveParts from "./saveParts";

const { SIGNED_HEADER_NAME } = constants;
const { addHeaderValue, resetHeader } = helper;
const { SmimeErrors } = exceptions;
const { CRYPTO_HEADERS } = enums;

export default async function verify(
    item: ItemValue<MailboxItem>,
    folderUid: string,
    getEml: () => Promise<string>
): Promise<MessageBody> {
    const body = item.value.body;
    let eml = await getEml();
    try {
        body.headers = resetHeader(body.headers, SIGNED_HEADER_NAME);
        const { content, toDigest, envelope } = pkcs7.parseSignedEml(body.structure!, eml);
        eml = content;
        await pkcs7.verify(envelope, toDigest, body);
        body.headers = addHeaderValue(body.headers, SIGNED_HEADER_NAME, CRYPTO_HEADERS.OK);
    } catch (error) {
        const errorCode = error instanceof SmimeErrors ? error.code : CRYPTO_HEADERS.UNKNOWN;
        body.headers = addHeaderValue(body.headers, SIGNED_HEADER_NAME, errorCode);
    }
    const { structure, preview } = await saveParts(eml, folderUid, item.value.imapUid!);
    body.preview = preview;
    body.structure = structure;
    return body;
}
