import { pki } from "node-forge";
import { exceptions } from "@bluemind/smime.commons";

export function isKeyReadable(pem: pki.PEM): boolean {
    try {
        return !!pki.privateKeyFromPem(pem);
    } catch (error) {
        throw new exceptions.InvalidKeyError(error);
    }
}
