import { describe, it, expect, vi } from "vitest";

import { SyncService } from "@bluemind/commons.light/model/synchronization";
import logger from "@bluemind/logger";

import SyncServiceProvider from "./SyncServiceProvider";

vi.mock("@bluemind/session", () => {
    return {
        default: {
            sid: vi.fn().mockReturnValue("sid")
        }
    };
});

type TestClass = new (a: string, b: string) => SyncService<testClass, string>;
class testClass {}
class ThrowingTestClass {
    constructor(uid: string, sid: string, domain: string) {
        throw new Error(`Failed to create sync service with uid: ${uid}`);
    }
}

describe("SyncServiceProvider", () => {
    let logSpy: ReturnType<typeof vi.spyOn>;

    beforeEach(() => {
        logSpy = vi.spyOn(logger, "error").mockImplementation(() => {});
    });

    afterEach(() => {
        logSpy.mockRestore();
    });

    it("should register and retrieve a sync service correctly", async () => {
        SyncServiceProvider.register(testClass as unknown as TestClass, "type");

        const sync = await SyncServiceProvider.get("uid", "type");

        expect(sync).toBeInstanceOf(testClass);
    });

    it("should throw an error when requesting an unregistered service type", async () => {
        SyncServiceProvider.register(testClass as unknown as TestClass, "type");

        const sync = await SyncServiceProvider.get("no", "nonExistentType");

        expect(sync).toBe(undefined);
    });
    it("should return undefined when constructor throws", async () => {
        SyncServiceProvider.register(ThrowingTestClass as unknown as TestClass, "throwingType");

        const sync = await SyncServiceProvider.get("uid", "throwingType");

        expect(sync).toBe(undefined);
    });
});
