import { MailboxItem, MailboxItemFlag } from "@bluemind/backend.mail.api";
import { cloneDeep } from "@bluemind/commons.light/utils/lang";
import { ItemFlag, ItemValue } from "@bluemind/core.container.api";

export default class {
    private item: ItemValue<MailboxItem & { conversationId: string }>;
    constructor(item: ItemValue<MailboxItem & { conversationId: string }>) {
        this.item = cloneDeep(item);
    }
    private rawFlag(flag: string): string {
        return (flag as string).replace(/\\/g, "");
    }
    private toItemFlag(flag: string): ItemFlag {
        const rawFlag = this.rawFlag(flag);

        const flagMapping = new Map([
            [this.rawFlag(MailboxItemFlag.System.Seen), ItemFlag.Seen],
            [this.rawFlag(MailboxItemFlag.System.Flagged), ItemFlag.Important],
            [this.rawFlag(MailboxItemFlag.System.Deleted), ItemFlag.Deleted]
        ]);

        return flagMapping.get(rawFlag) || (flag as unknown as ItemFlag);
    }

    addFlag(flag: string) {
        this.item.value.flags = [...new Set(this.item.value.flags || []).add(flag as MailboxItemFlag)];
        this.item.flags = [...new Set(this.item.flags || []).add(this.toItemFlag(flag))];
        return this;
    }

    removeFlag(flag: string) {
        this.item.value.flags = this.item.value.flags?.filter(flagValue => {
            return !(this.rawFlag(flagValue as string) === this.rawFlag(flag));
        });
        this.item.flags = this.item.flags?.filter(value => {
            return !(this.rawFlag(value) === this.rawFlag(this.toItemFlag(flag)));
        });
        return this;
    }

    toItem() {
        return this.item;
    }
}
