import { Router } from "workbox-routing";

import session from "@bluemind/session";

export default class extends Router {
    async handleRequest({ request, event }: { request: Request; event: ExtendableEvent }): Promise<Response> {
        const sid = request.headers.get("X-BM-ApiKey");

        if (sid) {
            await session.sync(sid);
        } else if (!session.isAuthenticated) {
            await session.authenticate();
        }

        const response = await super.handleRequest({ request, event });
        if (response) {
            return response;
        }

        return fetch(request);
    }
}
