import { h } from "vue";
import i18n from "@bluemind/i18n";
import app from "@bluemind/global.app";

import FhConfirmBox from "~/components/ConfirmBox";
import FhMustDetachConfirmBox from "~/components/MustDetachConfirmBox";
import { TooLargeBox } from "@bluemind/business-components";

export const LINKS_CLASSNAME = "filehosting-links";

export function renderMustDetachConfirmBox(files, sizeLimit, message) {
    const content = h(FhMustDetachConfirmBox, {
        files: sanitizeFiles(files),
        sizeLimit,
        allFilesCount: message.attachments?.length + files.length
    });
    const props = {
        title: i18n.global.tc("filehosting.add.large", files.length),
        okTitle: i18n.global.tc("filehosting.share.upload", files.length)
    };

    return { content, props };
}
export function renderShouldDetachConfirmBox(files) {
    const content = h(
        FhConfirmBox,
        {
            files: sanitizeFiles(files)
        },
        {
            text: () =>
                h("span", [
                    i18n.global.tc("filehosting.threshold.almost_hit", files.length),
                    h("br"),
                    i18n.global.tc("filehosting.share.upload", files.length),
                    " ?"
                ])
        }
    );
    const props = {
        size: "md",
        title: i18n.global.tc("filehosting.add.large", files.length),
        okTitle: i18n.global.tc("filehosting.share.upload", files.length),
        cancelTitle: i18n.global.t("mail.actions.attach")
    };

    return { content, props };
}

export async function renderTooLargeFilesModal(vm, files, sizeLimit) {
    const content = h(TooLargeBox, {
        sizeLimit,
        attachmentsCount: files.length,
        i18nPath: "filehosting.threshold.some_hit"
    });

    const props = {
        content,
        title: i18n.global.tc("mail.actions.attach.too_large", files.length),
        okLabel: i18n.global.tc("common.got_it"),
        okOnly: true,
        okVariant: "outline-accent",
        size: "md"
    };

    await app.config.globalProperties.$modalConfirm.confirm(props);
}

function sanitizeFiles(files) {
    return files.map(({ name, size }) => ({
        name,
        progress: { total: size, loaded: 0 }
    }));
}
