import app from "@bluemind/global.app";
import { extensions } from "@bluemind/extensions";
import { TranslationRegistry, default as i18n } from "@bluemind/i18n";
import injector from "@bluemind/inject";
import { AttachmentClient } from "@bluemind/attachment.api";
import FilehostingL10N from "./l10n";
import AddAttachmentsHandler from "~/handlers/AddAttachmentsHandler";
import RemoveAttachmentHandler from "~/handlers/RemoveAttachmentHandler";
import RenderlessFileItem from "~/components/RenderlessFileItem";
import RenderlessStore from "~/components/RenderlessStore";
import PreviewInvalid from "~/components/PreviewInvalid";
import CloudIcon from "~/components/CloudIcon";
import DetachButton from "~/components/DetachButton";
import ChooserButton from "~/components/ChooserButton";
import CopyToDriveItem from "~/components/OtherActionsItems/CopyToDriveItem";
import DetachItem from "~/components/OtherActionsItems/DetachItem";

TranslationRegistry.register(FilehostingL10N);

app.component("FhRenderlessFileItem", RenderlessFileItem);
app.component("CloudIcon", CloudIcon);
app.component("DetachButton", DetachButton);
app.component("ChooserButton", ChooserButton);
app.component("PreviewInvalid", PreviewInvalid);
app.component("CopyToDriveItem", CopyToDriveItem);
app.component("DetachItem", DetachItem);
app.component("FhRenderlessStore", RenderlessStore);

extensions.register("webapp", "net.bluemind.webmodules.filehosting", {
    command: {
        name: "add-attachments",
        fn: AddAttachmentsHandler,
        role: "canRemoteAttach"
    }
});

extensions.register("webapp", "net.bluemind.webmodules.filehosting", {
    command: {
        name: "remove-attachment",
        fn: RemoveAttachmentHandler,
        role: "canRemoteAttach",
        after: true
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "FhRenderlessFileItem",
        path: "message.file",
        priority: 10
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "CloudIcon",
        path: "attachment.infos.tags"
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "PreviewInvalid",
        path: "file.preview"
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    component: {
        name: "FhRenderlessStore",
        path: "app.header"
    }
});
injector.register({
    provide: "AttachmentPersistence",
    factory: () => {
        const userSession = injector.getProvider("UserSession").get();
        return new AttachmentClient(userSession.sid, userSession.domain);
    }
});

const detachMenuItem = {
    type: "button",
    key: "attach",
    items: [
        {
            key: "detach",
            label: i18n.global.t("filehosting.share.upload"),
            icon: "cloud-arrow-up",
            type: "custom",
            command: () => {},
            template: DetachButton
        }
    ]
};
extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "composer.footer.toolbar",
        role: "canRemoteAttach",
        priority: 128,
        "menu-item": detachMenuItem
    }
});

const ChooserMenuItem = {
    key: "attach",
    items: [
        {
            key: "chooser",
            label: i18n.global.t("filehosting.drive.from"),
            icon: "cloud",
            type: "custom",
            command: () => {},
            template: ChooserButton
        }
    ]
};
extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "composer.footer.toolbar",
        role: "canUseFilehosting",
        priority: 129,
        "menu-item": ChooserMenuItem
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "file.actions",
        role: "canRemoteAttach",
        priority: 128,
        "menu-item": {
            key: "detach",
            label: i18n.global.t("filehosting.detach"),
            icon: "cloud-arrow-up",
            type: "custom",
            template: DetachItem,
            overflow: "always"
        }
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "file.actions",
        role: "canUseFilehosting",
        priority: 128,
        "menu-item": {
            key: "toDrive",
            label: i18n.global.t("filehosting.drive.add"),
            icon: "cloud",
            type: "custom",
            template: CopyToDriveItem,
            overflow: "always"
        }
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "composer.mail.toolbar",
        role: "canRemoteAttach",
        priority: 128,
        "menu-item": detachMenuItem
    }
});

extensions.register("webapp.mail", "net.bluemind.webmodules.filehosting", {
    data: {
        path: "composer.mail.toolbar",
        role: "canUseFilehosting",
        priority: 129,
        "menu-item": ChooserMenuItem
    }
});
