/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.devmode.configurator;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.webmodule.project.vite.DevConfiguration;
import net.bluemind.webmodule.server.SecurityConfig;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodules.devmode.configurator.BundeConfigurationHandler;
import net.bluemind.webmodules.devmode.configurator.GlobalConfigurationHandler;

public abstract class DevConfigurationHandler {
    protected Vertx vertx;
    protected WebModule module;

    public static DevConfigurationHandler create(HttpServerRequest httpServerRequest, WebModule webModule, Vertx vertx) {
        String string = httpServerRequest.getParam("bundle");
        if (string != null) {
            return new BundeConfigurationHandler(string, webModule, vertx);
        }
        return new GlobalConfigurationHandler(webModule, vertx);
    }

    public DevConfigurationHandler(WebModule webModule, Vertx vertx) {
        this.module = webModule;
        this.vertx = vertx;
    }

    public void execute(HttpServerRequest httpServerRequest) {
        HttpMethod httpMethod = httpServerRequest.method();
        if (httpMethod.equals((Object)HttpMethod.POST)) {
            this.enable(httpServerRequest);
        } else if (httpMethod.equals((Object)HttpMethod.PUT)) {
            this.update(httpServerRequest);
        } else if (httpMethod.equals((Object)HttpMethod.DELETE)) {
            this.disable(httpServerRequest);
        } else if (httpMethod.equals((Object)HttpMethod.GET)) {
            this.get(httpServerRequest);
        } else {
            this.sendNotAllowed(httpServerRequest, "Methode %s is not allowed", httpMethod);
        }
    }

    protected abstract void update(HttpServerRequest var1);

    protected abstract void get(HttpServerRequest var1);

    protected abstract void disable(HttpServerRequest var1);

    protected abstract void enable(HttpServerRequest var1);

    protected void sendOk(HttpServerRequest httpServerRequest, String string, Object ... objectArray) {
        if (string != null) {
            string = String.format(string, objectArray);
        }
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.putHeader("Content-Type", "application/json");
        httpServerResponse.setStatusCode(200);
        httpServerResponse.end(JsonUtils.asString((Object)Status.OK(string)));
    }

    protected void sendNotFound(HttpServerRequest httpServerRequest, String string, Object ... objectArray) {
        if (string != null) {
            string = String.format(string, objectArray);
        }
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.putHeader("Content-Type", "application/json");
        httpServerResponse.setStatusCode(404);
        httpServerResponse.end(JsonUtils.asString((Object)Status.ERROR(string)));
    }

    protected void sendNotAllowed(HttpServerRequest httpServerRequest, String string, Object ... objectArray) {
        if (string != null) {
            string = String.format(string, objectArray);
        }
        HttpServerResponse httpServerResponse = httpServerRequest.response();
        httpServerResponse.putHeader("Content-Type", "application/json");
        httpServerResponse.setStatusCode(405);
        httpServerResponse.end(JsonUtils.asString((Object)Status.ERROR(string)));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected static class Status {
        private final String status;
        private final String message;
        private final DevConfiguration value;

        public Status(String string) {
            this(string, null);
        }

        public Status(String string, String string2) {
            this.status = string;
            this.message = string2;
            this.value = DevConfiguration.get();
        }

        public String getStatus() {
            return this.status;
        }

        public boolean getCSP() {
            return SecurityConfig.cspHeader;
        }

        public boolean getDevMode() {
            return DevConfiguration.DEV_MODE;
        }

        public String getMessage() {
            return this.message;
        }

        public DevConfiguration getValue() {
            return this.value;
        }

        public static Status ERROR(String string) {
            return new Status("error", string);
        }

        public static Status OK(String string) {
            return new Status("ok", string);
        }
    }
}

