/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.devmode.configurator;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.webmodule.project.vite.BundleDevConfiguration;
import net.bluemind.webmodule.project.vite.DevConfiguration;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.WebModuleResolver;
import net.bluemind.webmodules.devmode.configurator.DevConfigurationHandler;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundeConfigurationHandler
extends DevConfigurationHandler {
    private String bundleId;

    public BundeConfigurationHandler(String string, WebModule webModule, Vertx vertx) {
        super(webModule, vertx);
        this.bundleId = string;
    }

    @Override
    protected void get(HttpServerRequest httpServerRequest) {
        try {
            Bundle bundle = this.getBundle();
            BundleDevConfiguration bundleDevConfiguration = DevConfiguration.get().getBundleConfiguration(bundle);
            HttpServerResponse httpServerResponse = httpServerRequest.response();
            httpServerResponse.putHeader("Content-Type", "application/json");
            httpServerResponse.setStatusCode(200);
            httpServerResponse.end(JsonUtils.asString((Object)bundleDevConfiguration));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.sendNotFound(httpServerRequest, "Bundle %s not found", this.bundleId);
        }
    }

    @Override
    protected void disable(HttpServerRequest httpServerRequest) {
        try {
            Bundle bundle = this.getBundle();
            BundleDevConfiguration bundleDevConfiguration = DevConfiguration.get().getBundleConfiguration(bundle);
            if (bundleDevConfiguration == null) {
                this.sendNotFound(httpServerRequest, "Bundle %s is not a vite project", this.bundleId);
                return;
            }
            bundleDevConfiguration.disable();
            DevConfiguration.get().save();
            WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
            this.sendOk(httpServerRequest, "Bundle %s devmode has been disabled", this.bundleId);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.sendNotFound(httpServerRequest, "Bundle %s not found", this.bundleId);
        }
    }

    @Override
    protected void enable(HttpServerRequest httpServerRequest) {
        try {
            Bundle bundle = this.getBundle();
            BundleDevConfiguration bundleDevConfiguration = DevConfiguration.get().getBundleConfiguration(bundle);
            if (bundleDevConfiguration == null) {
                this.sendNotFound(httpServerRequest, "Bundle %s is not a vite project", this.bundleId);
                return;
            }
            bundleDevConfiguration.enable();
            DevConfiguration.get().enable();
            DevConfiguration.get().save();
            WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
            this.sendOk(httpServerRequest, "Bundle %s devmode has been enabled with server url %s", this.bundleId, bundleDevConfiguration.getServer());
        }
        catch (NoSuchElementException noSuchElementException) {
            this.sendNotFound(httpServerRequest, "Bundle %s not found", this.bundleId);
        }
    }

    private Bundle getBundle() {
        return Optional.ofNullable(Platform.getBundle((String)this.bundleId)).get();
    }

    @Override
    protected void update(HttpServerRequest httpServerRequest) {
        try {
            Bundle bundle = this.getBundle();
            BundleDevConfiguration bundleDevConfiguration = DevConfiguration.get().getBundleConfiguration(bundle);
            if (bundleDevConfiguration == null) {
                this.sendNotFound(httpServerRequest, "Bundle %s is not a vite project", this.bundleId);
                return;
            }
            httpServerRequest.bodyHandler(buffer -> {
                JsonObject jsonObject = buffer.toJsonObject();
                BundleDevConfiguration bundleDevConfiguration2 = (BundleDevConfiguration)jsonObject.mapTo(BundleDevConfiguration.class);
                bundleDevConfiguration.merge(bundleDevConfiguration2);
                DevConfiguration.get().save();
                WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
                this.sendOk(httpServerRequest, "Bunde %s configuration has been updated", this.bundleId);
            });
        }
        catch (NoSuchElementException noSuchElementException) {
            this.sendNotFound(httpServerRequest, "Bundle %s not found", this.bundleId);
        }
    }
}

