package net.bluemind.webmodules.devmode.configurator;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.handlers.IWebModuleConsumer;

public class DevModeHandler implements Handler<HttpServerRequest>, NeedVertx, IWebModuleConsumer {

	public static String PATH = "__devmode";
	private Vertx vertx;
	private WebModule module;

	@Override
	public void handle(HttpServerRequest request) {
		DevConfigurationHandler handler = DevConfigurationHandler.create(request, module, vertx);
		handler.execute(request);
	}

	@Override
	public void setModule(WebModule module) {
		this.module = module;
	}

	@Override
	public void setVertx(Vertx vertx) {
		this.vertx = vertx;
	}

}
