package net.bluemind.webmodules.devmode.configurator;

import java.util.NoSuchElementException;
import java.util.Optional;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.webmodule.project.vite.BundleDevConfiguration;
import net.bluemind.webmodule.project.vite.DevConfiguration;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.WebModuleResolver;

public class BundeConfigurationHandler extends DevConfigurationHandler {

	private String bundleId;

	public BundeConfigurationHandler(String bundle, WebModule module, Vertx vertx) {
		super(module, vertx);
		this.bundleId = bundle;
	}

	@Override
	protected void get(HttpServerRequest request) {
		try {
			Bundle bundle = getBundle();
			BundleDevConfiguration conf = DevConfiguration.get().getBundleConfiguration(bundle);
			HttpServerResponse resp = request.response();
			resp.putHeader("Content-Type", "application/json");
			resp.setStatusCode(200);
			resp.end(JsonUtils.asString(conf));
		} catch (NoSuchElementException e) {
			sendNotFound(request, "Bundle %s not found", bundleId);
		}
	}

	@Override
	protected void disable(HttpServerRequest request) {
		try {
			Bundle bundle = getBundle();
			BundleDevConfiguration conf = DevConfiguration.get().getBundleConfiguration(bundle);
			if (conf == null) {
				sendNotFound(request, "Bundle %s is not a vite project", bundleId);
				return;
			}
			conf.disable();
			DevConfiguration.get().save();
			WebModuleResolver.refresh(module, vertx);
			sendOk(request, "Bundle %s devmode has been disabled", bundleId);
		} catch (NoSuchElementException e) {
			sendNotFound(request, "Bundle %s not found", bundleId);
		}
	}

	@Override
	protected void enable(HttpServerRequest request) {
		try {
			Bundle bundle = getBundle();
			BundleDevConfiguration conf = DevConfiguration.get().getBundleConfiguration(bundle);
			if (conf == null) {
				sendNotFound(request, "Bundle %s is not a vite project", bundleId);
				return;
			}
			conf.enable();
			DevConfiguration.get().enable();
			DevConfiguration.get().save();
			WebModuleResolver.refresh(module, vertx);
//			if (conf.isAuto()) {
//				sendOk(request, "Bundle %s devmode has been enabled with server auto-detect", bundleId);
//			} else {
				sendOk(request, "Bundle %s devmode has been enabled with server url %s", bundleId, conf.getServer());
//			}
		} catch (NoSuchElementException e) {
			sendNotFound(request, "Bundle %s not found", bundleId);
		}

	}

	private Bundle getBundle() {
		return Optional.ofNullable(Platform.getBundle(bundleId)).get();
	}

	@Override
	protected void update(HttpServerRequest request) {
		try {
			Bundle bundle = getBundle();
			BundleDevConfiguration conf = DevConfiguration.get().getBundleConfiguration(bundle);
			if (conf == null) {
				sendNotFound(request, "Bundle %s is not a vite project", bundleId);
				return;
			}
			request.bodyHandler(buffer -> {
				JsonObject json = buffer.toJsonObject();
				BundleDevConfiguration input = json.mapTo(BundleDevConfiguration.class);
				conf.merge(input);
				DevConfiguration.get().save();
				WebModuleResolver.refresh(module, vertx);
				sendOk(request, "Bunde %s configuration has been updated", bundleId);
			});
		} catch (NoSuchElementException e) {
			sendNotFound(request, "Bundle %s not found", bundleId);
		}

	}

}
