package net.bluemind.webmodules.devmode.configurator;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import net.bluemind.webmodule.project.vite.DevConfiguration;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.WebModuleResolver;

public class GlobalConfigurationHandler extends DevConfigurationHandler {

	public GlobalConfigurationHandler(WebModule module, Vertx vertx) {
		super(module, vertx);
	}

	@Override
	protected void get(HttpServerRequest request) {
		sendOk(request, null);
	}

	@Override
	protected void disable(HttpServerRequest request) {
		DevConfiguration.get().disable();
		DevConfiguration.get().save();
		WebModuleResolver.refresh(module, vertx);
		sendOk(request, "Devmode has been disabled");
	}

	@Override
	protected void enable(HttpServerRequest request) {
		DevConfiguration.get().enable();
		DevConfiguration.get().save();
		WebModuleResolver.refresh(module, vertx);
		sendOk(request, "Devmod has been enabled");
	}

	@Override
	protected void update(HttpServerRequest request) {
		request.bodyHandler(buffer -> {
			JsonObject json = buffer.toJsonObject();
			DevConfiguration conf = json.mapTo(DevConfiguration.class);
			DevConfiguration.get().merge(conf);
			DevConfiguration.get().save();
			WebModuleResolver.refresh(module, vertx);
			sendOk(request, "Configuration has been updated");
		});

	}

}
