/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.devmode.configurator;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import net.bluemind.webmodule.project.vite.DevConfiguration;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.WebModuleResolver;
import net.bluemind.webmodules.devmode.configurator.DevConfigurationHandler;

public class GlobalConfigurationHandler
extends DevConfigurationHandler {
    public GlobalConfigurationHandler(WebModule webModule, Vertx vertx) {
        super(webModule, vertx);
    }

    @Override
    protected void get(HttpServerRequest httpServerRequest) {
        this.sendOk(httpServerRequest, null, new Object[0]);
    }

    @Override
    protected void disable(HttpServerRequest httpServerRequest) {
        DevConfiguration.get().disable();
        DevConfiguration.get().save();
        WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
        this.sendOk(httpServerRequest, "Devmode has been disabled", new Object[0]);
    }

    @Override
    protected void enable(HttpServerRequest httpServerRequest) {
        DevConfiguration.get().enable();
        DevConfiguration.get().save();
        WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
        this.sendOk(httpServerRequest, "Devmod has been enabled", new Object[0]);
    }

    @Override
    protected void update(HttpServerRequest httpServerRequest) {
        httpServerRequest.bodyHandler(buffer -> {
            JsonObject jsonObject = buffer.toJsonObject();
            DevConfiguration devConfiguration = (DevConfiguration)jsonObject.mapTo(DevConfiguration.class);
            DevConfiguration.get().merge(devConfiguration);
            DevConfiguration.get().save();
            WebModuleResolver.refresh((WebModule)this.module, (Vertx)this.vertx);
            this.sendOk(httpServerRequest, "Configuration has been updated", new Object[0]);
        });
    }
}

