/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.videoconferencing.api.IVideoConferencing.
 */

goog.provide('net.bluemind.videoconferencing.api.VideoConferencingVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.videoconferencing.api.IVideoConferencing API.
 * @param {string sessionId} sessionId
*  @param {string} containerUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.videoconferencing.api.VideoConferencingVertxClient = function( sessionId , containerUid ) {
  this.sessionId = sessionId;
  this.base = '/videoconferencing/{containerUid}';
  this.containerUid_ = containerUid;
  this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.videoconferencing.api.VideoConferencingVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.videoconferencing.api.VideoConferencingVertxClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} vevent
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingVertxClient.prototype.add = function( vevent  ) {

  var postUri = "";

  var params = {};



  var body = null;
  body = vevent;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingVertxClient.prototype.createResource = function( uid ,  descriptor  ) {

  var postUri = "/createResource/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} vevent
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingVertxClient.prototype.remove = function( vevent  ) {

  var postUri = "";

  var params = {};



  var body = null;
  body = vevent;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

