/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.videoconferencing.api.IVideoConferencing.
 */

goog.provide('net.bluemind.videoconferencing.api.VideoConferencingClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.videoconferencing.api.IVideoConferencing API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.videoconferencing.api.VideoConferencingClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/videoconferencing/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.videoconferencing.api.VideoConferencingClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.videoconferencing.api.VideoConferencingClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {Object} vevent
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingClient.prototype.add = function( vevent  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "add_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = vevent;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingClient.prototype.createResource = function( uid ,  descriptor  ) {

  var postUri = "/createResource/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "createResource_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} vevent
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferencingClient.prototype.remove = function( vevent  ) {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "remove_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  body = vevent;
  return this.execute(cmd, body);
};

