/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.videoconferencing.api.IVideoConferenceUids.
 */

goog.provide('net.bluemind.videoconferencing.api.VideoConferenceUidsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.videoconferencing.api.IVideoConferenceUids API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.videoconferencing.api.VideoConferenceUidsClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/videoconferencing/uids';
};

goog.inherits(net.bluemind.videoconferencing.api.VideoConferenceUidsClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferenceUidsClient.prototype.getProviderTypeUid = function() {

  var postUri = "/provider_type";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getProviderTypeUid_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.videoconferencing.api.VideoConferenceUidsClient.prototype.getResourceTypeUid = function() {

  var postUri = "/resource_type_uid";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getResourceTypeUid_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

