/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.client.forms.apikeys;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import net.bluemind.authentication.api.APIKey;
import net.bluemind.authentication.api.IAPIKeysAsync;
import net.bluemind.authentication.api.gwt.endpoint.APIKeysGwtEndpoint;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.notification.Notification;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.common.client.icon.Trash;
import net.bluemind.ui.settings.client.forms.apikeys.AKConstants;

public class AKPanel
extends CompositeGwtWidgetElement {
    private final IAPIKeysAsync apiKeys = new APIKeysGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]);
    private static AKPanelUiBinder uiBinder = (AKPanelUiBinder)GWT.create(AKPanelUiBinder.class);
    private static final Resources res = (Resources)GWT.create(Resources.class);
    private final Style s = res.editStyle();
    @UiField
    Button createBtn;
    @UiField
    TextBox dn;
    @UiField
    FlexTable table;

    @UiHandler(value={"dn"})
    public void onKeyUpEvent(KeyUpEvent keyUpEvent) {
        if (keyUpEvent.getNativeKeyCode() == 13 && !this.dn.getValue().isEmpty()) {
            this.genApiKey();
        }
    }

    public AKPanel() {
        this.s.ensureInjected();
        FlowPanel flowPanel = new FlowPanel();
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        flowPanel.add((Widget)hTMLPanel);
        this.initWidget((Widget)flowPanel);
        this.table.setStyleName(this.s.container());
        this.createBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                AKPanel.this.genApiKey();
            }
        });
        this.dn.getElement().setAttribute("placeholder", AKConstants.INST.dn());
        this.getApiKeys();
    }

    private void getApiKeys() {
        this.table.clear();
        this.apiKeys.list((AsyncHandler)new AsyncHandler<List<APIKey>>(){

            public void success(List<APIKey> list) {
                for (APIKey aPIKey : list) {
                    AKPanel.this.addEntry(aPIKey);
                }
            }

            public void failure(Throwable throwable) {
                Notification.get().reportError(throwable);
            }
        });
    }

    private void addEntry(APIKey aPIKey) {
        Trash trash = new Trash();
        trash.addClickHandler(clickEvent -> {
            if (Window.confirm((String)AKConstants.INST.confirmDelete(aPIKey.displayName))) {
                HTMLTable.Cell cell = this.table.getCellForEvent(clickEvent);
                this.table.removeRow(cell.getRowIndex());
                this.revokeApiKey(aPIKey.sid);
            }
        });
        int n = this.table.getRowCount();
        int n2 = 0;
        FlowPanel flowPanel = new FlowPanel();
        Label label = new Label(aPIKey.sid);
        label.setStyleName(this.s.sid());
        flowPanel.add((Widget)label);
        Label label2 = new Label(aPIKey.displayName);
        label2.setStyleName(this.s.dn());
        flowPanel.add((Widget)label2);
        this.table.setWidget(n, n2++, (Widget)flowPanel);
        this.table.setWidget(n, n2++, (Widget)trash);
        this.table.getRowFormatter().setStyleName(n, this.s.item());
    }

    private void revokeApiKey(String string) {
        this.apiKeys.delete(string, (AsyncHandler)new AsyncHandler<Void>(){

            public void failure(Throwable throwable) {
                Notification.get().reportError(throwable);
            }

            public void success(Void void_) {
                Notification.get().reportInfo(AKConstants.INST.deleteOk());
            }
        });
    }

    private void genApiKey() {
        if (this.dn.getValue().isEmpty()) {
            Window.alert((String)AKConstants.INST.dnIsEmpty());
        } else {
            this.apiKeys.create(this.dn.getValue(), (AsyncHandler)new AsyncHandler<APIKey>(){

                public void success(APIKey aPIKey) {
                    AKPanel.this.dn.setValue(null);
                    AKPanel.this.addEntry(aPIKey);
                    Notification.get().reportInfo(AKConstants.INST.insertOk());
                }

                public void failure(Throwable throwable) {
                    Notification.get().reportError(throwable);
                }
            });
        }
    }

    public static native ScreenElement create();

    public static void registerType() {
        GwtWidgetElement.register((String)"bm.settings.ApiKeysEditor", (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new AKPanel();
            }
        });
    }

    static interface AKPanelUiBinder
    extends UiBinder<HTMLPanel, AKPanel> {
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"AKPanel.css"})
        public Style editStyle();
    }

    public static interface Style
    extends CssResource {
        public String container();

        public String item();

        public String sid();

        public String dn();
    }
}

