/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.client.about;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.system.api.IInstallationAsync;
import net.bluemind.system.api.InstallationVersion;
import net.bluemind.system.api.SubscriptionInformations;
import net.bluemind.system.api.gwt.endpoint.InstallationGwtEndpoint;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.settings.client.about.AboutConstants;
import net.bluemind.ui.settings.client.about.LicTexts;

public class AboutPanel
extends CompositeGwtWidgetElement {
    @UiField
    Image close;
    @UiField
    Label copyright;
    @UiField
    Label version;
    @UiField
    FlowPanel infosPanel;
    @UiField
    FocusPanel root;
    private static final int BLUEMIND_YEAR_OF_BIRTH = 2012;
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private IInstallationAsync installation = new InstallationGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]);

    public AboutPanel() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.version.setText(AboutConstants.INST.version("", ""));
        Date date = new Date();
        int n = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
        if (n - 2012 == 0) {
            this.copyright.setText(AboutConstants.INST.copyright(Integer.toString(2012)));
        } else {
            this.copyright.setText(AboutConstants.INST.copyright("2012 - " + n));
        }
        this.root.setFocus(true);
        this.loadServerInfos();
    }

    private void loadServerInfos() {
        this.installation.getVersion((AsyncHandler)new AsyncHandler<InstallationVersion>(){

            public void success(InstallationVersion installationVersion) {
                AboutPanel.this.version.setText(AboutConstants.INST.version(installationVersion.versionName, installationVersion.softwareVersion));
            }

            public void failure(Throwable throwable) {
            }
        });
        this.installation.getSubscriptionInformations((AsyncHandler)new AsyncHandler<SubscriptionInformations>(){

            public void success(SubscriptionInformations subscriptionInformations) {
                AboutPanel.this.infosPanel.add((Widget)new Label(LicTexts.INST.lic_signed_customer() + ": " + subscriptionInformations.customer));
                AboutPanel.this.infosPanel.add((Widget)new Label(LicTexts.INST.lic_signed_customer_code() + ": " + subscriptionInformations.customerCode));
            }

            public void failure(Throwable throwable) {
            }
        });
    }

    @UiHandler(value={"close"})
    void handleClick(ClickEvent clickEvent) {
        this.hide();
    }

    @UiHandler(value={"root"})
    void handleKeyboardClose(KeyPressEvent keyPressEvent) {
        if (keyPressEvent.getNativeEvent().getKeyCode() == 27) {
            this.hide();
        }
    }

    private void hide() {
        History.back();
    }

    public static void registerType() {
        GwtWidgetElement.register((String)"bm.settings.About", (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                ScreenRoot screenRoot = (ScreenRoot)widgetElement.cast();
                screenRoot.setOverlay(true);
                return new AboutPanel();
            }
        });
    }

    public static native ScreenElement create();

    static interface Binder
    extends UiBinder<Widget, AboutPanel> {
    }
}

