/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.settings.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import net.bluemind.gwtconsoleapp.base.editor.BasePlugin;
import net.bluemind.gwtconsoleapp.base.editor.EditorContext;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElementContributor;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElementContributorUnwrapper;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElements;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.eventbus.GwtEventBus;
import net.bluemind.gwtconsoleapp.base.eventbus.NotificationEvent;
import net.bluemind.gwtconsoleapp.base.eventbus.NotificationEventHandler;
import net.bluemind.gwtconsoleapp.base.lifecycle.GwtAppLifeCycle;
import net.bluemind.gwtconsoleapp.base.lifecycle.ILifeCycle;
import net.bluemind.gwtconsoleapp.base.menus.MenuContributor;
import net.bluemind.gwtconsoleapp.base.menus.MenuContributorUnwrapped;
import net.bluemind.gwtconsoleapp.base.notification.Notification;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.settings.addressbook.AddressBookSettingsPlugin;
import net.bluemind.ui.settings.calendar.CalendarSettingsPlugin;
import net.bluemind.ui.settings.client.MainMenusContributor;
import net.bluemind.ui.settings.client.MainScreensContributor;
import net.bluemind.ui.settings.client.NotificationPanel;
import net.bluemind.ui.settings.client.RootScreen;
import net.bluemind.ui.settings.client.SettingsScreen;
import net.bluemind.ui.settings.client.about.AboutPanel;
import net.bluemind.ui.settings.client.forms.apikeys.AKPanel;
import net.bluemind.ui.settings.client.myaccount.MyAccountPlugin;
import net.bluemind.ui.settings.mail.MailSettingsPlugin;
import net.bluemind.ui.settings.task.TaskSettingsPlugin;

public class Settings
implements EntryPoint {
    public boolean alreadyStarted = false;

    public void onModuleLoad() {
        BasePlugin.install();
        RootScreen.registerType();
        SettingsScreen.registerType();
        AboutPanel.registerType();
        AKPanel.registerType();
        MyAccountPlugin.install();
        ScreenElementContributor.exportAsfunction((String)"gwtSettingsMainScreensContributor", (ScreenElementContributor)ScreenElementContributor.create((ScreenElementContributorUnwrapper)new MainScreensContributor()));
        MenuContributor.exportAsfunction((String)"gwtSettingsMainMenusContributor", (MenuContributor)MenuContributor.create((MenuContributorUnwrapped)new MainMenusContributor()));
        MailSettingsPlugin.install();
        CalendarSettingsPlugin.install();
        AddressBookSettingsPlugin.install();
        TaskSettingsPlugin.install();
        GwtAppLifeCycle.registerLifeCycle((String)"net.bluemind.ui.settings", (ILifeCycle)new ILifeCycle(){

            public void start() {
                RestBusImpl.get().addListener(bl -> {
                    if (bl && !Settings.this.alreadyStarted) {
                        Settings.this.alreadyStarted = true;
                        Settings.this.startUp();
                    }
                });
            }
        });
    }

    protected void startUp() {
        RootLayoutPanel rootLayoutPanel = RootLayoutPanel.get();
        rootLayoutPanel.getElement().addClassName("root-layout");
        FlowPanel flowPanel = new FlowPanel();
        flowPanel.setHeight("100%");
        rootLayoutPanel.clear();
        rootLayoutPanel.add((Widget)flowPanel);
        ScreenElements screenElements = new ScreenElements("net.bluemind.ui.settings.screensContributor");
        ScreenElement screenElement = screenElements.getElement("base");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("userId", Ajax.TOKEN.getSubject());
        hashMap.put("entryUid", Ajax.TOKEN.getSubject());
        hashMap.put("mailboxUid", Ajax.TOKEN.getSubject());
        hashMap.put("domainUid", Ajax.TOKEN.getContainerUid());
        ScreenRoot screenRoot = ScreenRoot.build((ScreenRoot)((ScreenRoot)screenElement.cast()), hashMap, (EditorContext)EditorContext.create((Collection)Ajax.TOKEN.getRoles()));
        screenRoot.attach((Element)flowPanel.getElement());
        Notification.exportNotificationFunction();
        NotificationPanel notificationPanel = new NotificationPanel();
        this.registerNotificationHandler(notificationPanel);
        RootPanel.get().add((Widget)notificationPanel);
    }

    private void registerNotificationHandler(final NotificationPanel notificationPanel) {
        GwtEventBus.bus.addHandler(NotificationEvent.TYPE, (EventHandler)new NotificationEventHandler(){

            public void onNotify(NotificationEvent notificationEvent) {
                switch (notificationEvent.notificationType) {
                    case INFO: {
                        GWT.log((String)("INFO: " + notificationEvent.message));
                        break;
                    }
                    case ERROR: 
                    case EXCEPTION: {
                        GWT.log((String)("ERROR: " + notificationEvent.message));
                    }
                }
            }
        });
        GwtEventBus.bus.addHandler(NotificationEvent.TYPE, (EventHandler)new NotificationEventHandler(){

            public void onNotify(NotificationEvent notificationEvent) {
                switch (notificationEvent.notificationType) {
                    case INFO: {
                        notificationPanel.showOk(notificationEvent.message);
                        break;
                    }
                    case ERROR: {
                        notificationPanel.showError(notificationEvent.message);
                        break;
                    }
                    case EXCEPTION: {
                        notificationPanel.showError(notificationEvent.exception.getMessage());
                    }
                }
            }
        });
    }
}

