/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.monitoring.screens;

import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.ui.adminconsole.monitoring.l10n.ScreensConstants;
import net.bluemind.ui.adminconsole.monitoring.screens.HtmlColumn;

public class HotUpgradeTasksGrid
extends DataGrid<HotUpgradeTask> {
    public static DateTimeFormat sdf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM);
    private static final ScreensConstants txt = ScreensConstants.INST;
    private ListDataProvider<HotUpgradeTask> ldp;
    private HtmlColumn<HotUpgradeTask> operation;
    private TextColumn<HotUpgradeTask> createdAt;
    private TextColumn<HotUpgradeTask> updatedAt;
    private HtmlColumn<HotUpgradeTask> status;
    private TextColumn<HotUpgradeTask> executionMode;
    private HtmlColumn<HotUpgradeTask> mandatory;

    public HotUpgradeTasksGrid() {
        this.createColums();
        this.setHeight("100%");
        this.setEmptyTableWidget(null);
        this.setLoadingIndicator(null);
        this.setPageSize(Integer.MAX_VALUE);
        this.ldp = new ListDataProvider();
        this.ldp.addDataDisplay((HasData)this);
        ColumnSortEvent.AsyncHandler asyncHandler = new ColumnSortEvent.AsyncHandler((HasData)this);
        this.addColumnSortHandler((ColumnSortEvent.Handler)asyncHandler);
        AsyncDataProvider<HotUpgradeTask> asyncDataProvider = new AsyncDataProvider<HotUpgradeTask>(){

            protected void onRangeChanged(HasData<HotUpgradeTask> hasData) {
                ColumnSortList columnSortList = HotUpgradeTasksGrid.this.getColumnSortList();
                if (columnSortList.size() > 0) {
                    ColumnSortList.ColumnSortInfo columnSortInfo = columnSortList.get(0);
                    boolean bl = columnSortInfo.isAscending();
                    List<HotUpgradeTask> list = HotUpgradeTasksGrid.this.getValues();
                    if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.operation)) {
                        Collections.sort(list, Comparator.comparing(hotUpgradeTask -> hotUpgradeTask.operation));
                    } else if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.createdAt)) {
                        Collections.sort(list, (hotUpgradeTask, hotUpgradeTask2) -> hotUpgradeTask.createdAt.compareTo(hotUpgradeTask2.createdAt));
                    } else if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.updatedAt)) {
                        Collections.sort(list, (hotUpgradeTask, hotUpgradeTask2) -> hotUpgradeTask.updatedAt.compareTo(hotUpgradeTask2.updatedAt));
                    } else if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.updatedAt)) {
                        Collections.sort(list, Comparator.comparing(hotUpgradeTask -> hotUpgradeTask.status.name()));
                    } else if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.executionMode)) {
                        Collections.sort(list, Comparator.comparing(hotUpgradeTask -> hotUpgradeTask.executionMode.name()));
                    } else if (columnSortInfo.getColumn().equals(HotUpgradeTasksGrid.this.mandatory)) {
                        Collections.sort(list, Comparator.comparing(hotUpgradeTask -> hotUpgradeTask.mandatory));
                    }
                    if (!bl) {
                        Collections.reverse(list);
                    }
                    HotUpgradeTasksGrid.this.setValues(list);
                }
            }
        };
        asyncDataProvider.addDataDisplay((HasData)this);
    }

    private void createColums() {
        TextColumn<HotUpgradeTask> textColumn = new TextColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                return "" + hotUpgradeTask.id;
            }
        };
        this.addColumn((Column)textColumn, "ID", "ID");
        this.setColumnWidth((Column)textColumn, 20.0, Style.Unit.PCT);
        this.operation = new HtmlColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                return "<b>" + hotUpgradeTask.operation + "</b>";
            }
        };
        this.addColumn(this.operation, txt.operation(), txt.operation());
        this.setColumnWidth(this.operation, 60.0, Style.Unit.PCT);
        this.operation.setSortable(true);
        this.createdAt = new TextColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                if (hotUpgradeTask.createdAt != null) {
                    return sdf.format(hotUpgradeTask.createdAt);
                }
                return "";
            }
        };
        this.addColumn((Column)this.createdAt, txt.createdAt(), txt.createdAt());
        this.setColumnWidth((Column)this.createdAt, 40.0, Style.Unit.PCT);
        this.createdAt.setSortable(true);
        this.updatedAt = new TextColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                if (hotUpgradeTask.updatedAt != null) {
                    return sdf.format(hotUpgradeTask.updatedAt);
                }
                return "";
            }
        };
        this.addColumn((Column)this.updatedAt, txt.updatedAt(), txt.updatedAt());
        this.setColumnWidth((Column)this.updatedAt, 40.0, Style.Unit.PCT);
        this.updatedAt.setSortable(true);
        this.status = new HtmlColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                switch (hotUpgradeTask.status) {
                    case SUCCESS: 
                    case PLANNED: {
                        return hotUpgradeTask.status.name();
                    }
                    case FAILURE: {
                        return "<p style=\"color:red\">" + hotUpgradeTask.status.name() + "</p>";
                    }
                }
                return "";
            }
        };
        this.addColumn(this.status, txt.status(), txt.status());
        this.setColumnWidth(this.status, 25.0, Style.Unit.PCT);
        this.status.setSortable(true);
        this.executionMode = new TextColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                return hotUpgradeTask.executionMode.name();
            }
        };
        this.addColumn((Column)this.executionMode, txt.executionMode(), txt.executionMode());
        this.setColumnWidth((Column)this.executionMode, 40.0, Style.Unit.PCT);
        this.executionMode.setSortable(true);
        this.mandatory = new HtmlColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                return hotUpgradeTask.mandatory ? "<b>" + Boolean.toString(hotUpgradeTask.mandatory) + "</b>" : Boolean.toString(hotUpgradeTask.mandatory);
            }
        };
        this.addColumn(this.mandatory, txt.mandatory(), txt.mandatory());
        this.setColumnWidth(this.mandatory, 40.0, Style.Unit.PCT);
        this.mandatory.setSortable(true);
        HtmlColumn<HotUpgradeTask> htmlColumn = new HtmlColumn<HotUpgradeTask>(){

            public String getValue(HotUpgradeTask hotUpgradeTask) {
                return hotUpgradeTask.events.stream().map(hotUpgradeStepEvent -> {
                    String string = "<b>" + sdf.format(new Date(hotUpgradeStepEvent.date)) + "</b>";
                    return string + ": " + hotUpgradeStepEvent.status.name() + ": " + hotUpgradeStepEvent.message;
                }).reduce("", (string, string2) -> string + string2 + "<br>");
            }
        };
        this.addColumn(htmlColumn, txt.events(), txt.events());
        this.setColumnWidth(htmlColumn, 100.0, Style.Unit.PCT);
    }

    public void setValues(List<HotUpgradeTask> list) {
        this.ldp.setList(list);
        this.ldp.refresh();
    }

    public List<HotUpgradeTask> getValues() {
        return this.ldp.getList();
    }

    public void refresh() {
        this.ldp.refresh();
    }
}

