/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.sharedmailbox;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;

import net.bluemind.core.api.gwt.js.JsEmail;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer;
import net.bluemind.domain.api.Domain;
import net.bluemind.domain.api.DomainSettingsKeys;
import net.bluemind.domain.api.gwt.serder.DomainGwtSerDer;
import net.bluemind.gwtconsoleapp.base.editor.ContainerElement;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtContainerElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtContainerElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.mailbox.api.Mailbox.Routing;
import net.bluemind.mailbox.api.gwt.js.JsMailboxRouting;
import net.bluemind.role.api.BasicRoles;
import net.bluemind.ui.admin.client.forms.QuotaEdit;
import net.bluemind.ui.adminconsole.base.ui.MailAddressTableEditor;
import net.bluemind.ui.adminconsole.directory.sharedmailbox.l10n.SharedMailboxConstants;
import net.bluemind.ui.common.client.forms.StringEdit;
import net.bluemind.ui.mailbox.filter.MailForwardEditor;
import net.bluemind.ui.mailbox.filter.SieveEdit;
import net.bluemind.ui.mailbox.vacation.MailVacationEditor;
import net.bluemind.user.api.gwt.js.JsUser;
import net.bluemind.ui.adminconsole.directory.user.UserMailEditor;

public class SharedMailboxMailEditor extends UserMailEditor {

	private static UserMailUiBinder uiBinder = GWT.create(UserMailUiBinder.class);

	interface UserMailUiBinder extends UiBinder<HTMLPanel, SharedMailboxMailEditor> {
	}

	protected SharedMailboxMailEditor(ContainerElement model) {
		super(model);
	}

	@Override
	protected void attachChild(WidgetElement widgetElement) {
		if (widgetElement.getTitle() != null) {
			Element div = DOM.createDiv();
			div.setInnerText(widgetElement.getTitle());
			div.addClassName("sectionTitle");
			ext.getElement().appendChild(div);
		}
		widgetElement.attach(ext.getElement());
	}

	@Override
	public void loadModel(JavaScriptObject model) {
		login = null;
		JsMapStringJsObject map = model.cast();
		JsUser sharedMailbox = map.get("sharedMailbox").cast();
		super.loadJsUser(sharedMailbox, map);
	}

	@Override
	public void saveModel(JavaScriptObject model) {
		JsMapStringJsObject map = model.cast();
		JsUser sharedMailbox = map.get("sharedMailbox").cast();
		super.saveJsUser(sharedMailbox);
		sharedMailbox.setLoginCaps(false);
	}

	public static void registerType() {
		GwtContainerElement.register("bm.ac.SharedMailboxMailEditor",
				new IGwtDelegateFactory<IGwtContainerElement, ContainerElement>() {

					@Override
					public IGwtContainerElement create(ContainerElement e) {
						return new SharedMailboxMailEditor(e);
					}
				});
	}

	public static ScreenElement model() {

		JsArray<ScreenElement> children = JsArray.createArray().cast();
		children.push(
				ScreenElement.create(null, SharedMailboxMailboxSharingEditor.TYPE).witTitle(SharedMailboxConstants.INST.mailboxSharing()));
		children.push(
				ScreenElement.create(null, MailForwardEditor.TYPE).withRole(BasicRoles.ROLE_MANAGE_MAILBOX_FILTER));
		children.push(
				ScreenElement.create(null, MailVacationEditor.TYPE).withRole(BasicRoles.ROLE_MANAGE_MAILBOX_FILTER));
		children.push(ScreenElement.create(null, SieveEdit.TYPE).withRole(BasicRoles.ROLE_MANAGE_MAILBOX_FILTER));

		// FIXME use "native ContainerElement"
		return ContainerElement.createWithType("editSharedMailboxMail", "bm.ac.SharedMailboxMailEditor", children);
	}

}
