/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.sharedmailbox;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;

import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.gwtconsoleapp.base.editor.ContainerElement;
import net.bluemind.gwtconsoleapp.base.editor.ModelHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.Tab;
import net.bluemind.gwtconsoleapp.base.editor.TabContainer;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtCompositeScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.role.api.BasicRoles;
import net.bluemind.ui.adminconsole.base.Actions;
import net.bluemind.ui.adminconsole.base.orgunit.OrgUnitsAdministratorModelHandler;
import net.bluemind.ui.adminconsole.base.ui.BaseDirEntryEditScreen;
import net.bluemind.ui.adminconsole.directory.commons.ExternalIdEditor;
import net.bluemind.ui.adminconsole.directory.mailbox.MailboxMaintenance;
import net.bluemind.ui.adminconsole.directory.mailshare.DomainLoader;
import net.bluemind.ui.adminconsole.directory.sharedmailbox.l10n.SharedMailboxConstants;
import net.bluemind.ui.adminconsole.directory.sharedmailbox.l10n.SharedMailboxMenusConstants;
import net.bluemind.ui.gwtuser.client.BooksSubscriptionsEditor;
import net.bluemind.ui.gwtuser.client.CalendarManagementModelHandler;
import net.bluemind.ui.gwtuser.client.CalendarsSubscriptionsEditor;
import net.bluemind.ui.gwtuser.client.UserBooksSharingModelHandler;
import net.bluemind.ui.gwtuser.client.UserBooksSharingsEditor;
import net.bluemind.ui.gwtuser.client.UserBooksSubscriptionModelHandler;
import net.bluemind.ui.gwtuser.client.UserCalendarsSharingModelHandler;
import net.bluemind.ui.gwtuser.client.UserCalendarsSharingsEditor;
import net.bluemind.ui.gwtuser.client.UserCalendarsSubscriptionModelHandler;
import net.bluemind.ui.gwtuser.client.UserSettingsModelHandler;
import net.bluemind.ui.gwtuser.client.UserTodolistsSharingModelHandler;
import net.bluemind.ui.gwtuser.client.UserTodolistsSharingsEditor;
import net.bluemind.ui.gwtuser.client.UserTodolistsSubscriptionModelHandler;
import net.bluemind.ui.gwtuser.client.UserTodolistsSubscriptionsEditor;
import net.bluemind.ui.mailbox.filter.MailSettingsModelHandler;
import net.bluemind.ui.mailbox.identity.UserMailIdentitiesModelHandler;
import net.bluemind.ui.settings.calendar.GeneralPartWidget;
import net.bluemind.user.api.gwt.js.JsUser;

public class EditSharedMailboxScreen extends BaseDirEntryEditScreen {

	public static final String TYPE = "bm.ac.EditSharedMailboxScreen";

	public interface BBBundle extends ClientBundle {

		@Source("EditSharedMailbox.css")
		BBStyle getStyle();

	}

	public interface BBStyle extends CssResource {
		String archive();

		String typeColumn();

		String appLink();
	}

	private static final BBBundle bundle = GWT.create(BBBundle.class);

	private EditSharedMailboxScreen(ScreenRoot screenRoot) {
		super(screenRoot);
		icon.setStyleName("fa fa-2x fa-envelope-square");

	}

	public void loadModel(JavaScriptObject model) {
		JsMapStringJsObject map = model.cast();
		JsUser sharedMailbox = map.get("sharedMailbox").cast();

		title.setInnerText(SharedMailboxConstants.INST.editTitle(sharedMailbox.getLogin()));
		if (sharedMailbox.getArchived()) {
			title.setClassName(bundle.getStyle().archive());
		}
	}

	@Override
	public void doLoad(final ScreenRoot instance) {
		GWT.log("load model");

		instance.getState().put("dirEntryId", instance.getState().get("entryUid"));
		instance.getState().put("entryUid", instance.getState().get("entryUid"));
		instance.getState().put("mailboxUid", instance.getState().get("dirEntryId"));
		instance.getState().put("dirEntryUid", instance.getState().get("dirEntryId"));
		instance.getState().put("domainUid", instance.getState().get("domainUid"));
		super.doLoad(instance);
	}

	public static void registerType() {
		GwtScreenRoot.registerComposite(TYPE, new IGwtDelegateFactory<IGwtCompositeScreenRoot, ScreenRoot>() {

			@Override
			public IGwtCompositeScreenRoot create(ScreenRoot screenRoot) {
				return new EditSharedMailboxScreen(screenRoot);
			}
		});
	}

	@Override
	protected void doCancel() {
		Actions.get().showWithParams2("directory", null);
	}


	/**
	* The ACL handlers need to be executed in order: 
	* the mailbox sharing handler should be called AFTER the container ACL handlers, 
	* since some hooks that act on the mailbox sharing handler also change ACLs.
	*/
	private static void aclHandlers(ScreenRoot screenRoot) {
		screenRoot.getHandlers().push(ModelHandler.create(null, UserBooksSharingModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, UserCalendarsSharingModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, UserTodolistsSharingModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS).<ModelHandler>cast());
				
		screenRoot.getHandlers().push(ModelHandler.create(null, SharedMailboxMailboxSharingModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS).<ModelHandler>cast());
	}

	public static ScreenElement screenModel() {
		SharedMailboxMenusConstants c = GWT.create(SharedMailboxMenusConstants.class);
		ScreenRoot screenRoot = ScreenRoot.create("editSharedMailbox", TYPE).cast();
		screenRoot.getHandlers().push(ModelHandler.create(null, EditSharedMailboxModelHandler.TYPE).readOnly()
				.withRoles(BasicRoles.ROLE_MANAGE_USER, BasicRoles.ROLE_MANAGE_USER_VCARD).<ModelHandler>cast());
		
		// this should be called before shared_mailbox final update, 
		// because some hooks that act on the mailbox update also change mail filters
		screenRoot.getHandlers().push(ModelHandler.create(null, MailSettingsModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_MAILBOX_FILTER).<ModelHandler>cast());

		aclHandlers(screenRoot);

		screenRoot.getHandlers().push(ModelHandler.create(null, UserSettingsModelHandler.TYPE).readOnly()
				.withRole(BasicRoles.ROLE_MANAGE_USER_SETTINGS).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, UserCalendarsSubscriptionModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, UserBooksSubscriptionModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS).<ModelHandler>cast());

		screenRoot.getHandlers().push(ModelHandler.create(null, UserMailIdentitiesModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_MAIL_IDENTITIES).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, DomainLoader.TYPE).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, UserTodolistsSubscriptionModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS).<ModelHandler>cast());
		screenRoot.getHandlers().push(ModelHandler.create(null, CalendarManagementModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER).<ModelHandler>cast());

		screenRoot.getHandlers().push(ModelHandler.create(null, OrgUnitsAdministratorModelHandler.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER).<ModelHandler>cast());

		JsArray<Tab> tabs = JavaScriptObject.createArray().cast();
		// general
		JsArray<ScreenElement> editSharedMailboxGeneralContents = JsArray.createArray().cast();
		editSharedMailboxGeneralContents.push(
				ScreenElement.create(null, SharedMailboxGeneralEditor.TYPE).readOnly().withRole(BasicRoles.ROLE_MANAGE_USER));
		editSharedMailboxGeneralContents.push(ScreenElement.create(null, SharedMailboxSettingsEditor.TYPE).readOnly()
				.withRole(BasicRoles.ROLE_MANAGE_USER_SETTINGS));

		ContainerElement editSharedMailboxGeneral = ContainerElement.create("editSharedMailboxGeneral", editSharedMailboxGeneralContents);
		tabs.push(Tab.create(null, c.generalTab(), editSharedMailboxGeneral));

		// vcard
		tabs.push(Tab.create(null, c.sharedMailboxVCardTab(), ScreenElement.create(null, "bluemind.contact.ui.ContactEditor")
				.withRole(BasicRoles.ROLE_MANAGE_USER_VCARD)));

		// mail
		ScreenElement mailEditor = SharedMailboxMailEditor.model();
		tabs.push(Tab.create(null, c.mailSettingsTab(), mailEditor));

		// addressbooks
		JsArray<ScreenElement> addressbooksContent = JsArray.createArray().cast();
		addressbooksContent.push(ScreenElement.create(null, BooksSubscriptionsEditor.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS));
		addressbooksContent.push(ScreenElement.create(null, UserBooksSharingsEditor.TYPE)
				.witTitle(c.addressBooksSharingsTab()).withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS));
		tabs.push(Tab.create(null, c.addressBooksTab(),
				ContainerElement.create("editSharedMailboxAddressBook", addressbooksContent)));

		// calendars
		JsArray<ScreenElement> calendarsContent = JsArray.createArray().cast();
		calendarsContent.push(ScreenElement.create(null, GeneralPartWidget.TYPE).readOnly()
				.withRole(BasicRoles.ROLE_MANAGE_USER_SETTINGS));
		calendarsContent.push(ScreenElement.create(null, SharedMailboxCalendarsEditor.TYPE).witTitle(c.sharedMailboxCalendars())
				.withRole(BasicRoles.ROLE_MANAGE_USER));

		calendarsContent.push(ScreenElement.create(null, UserCalendarsSharingsEditor.TYPE)
				.witTitle(c.calendarsSharingTab()).withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS));

		calendarsContent.push(ScreenElement.create(null, CalendarsSubscriptionsEditor.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS));
		tabs.push(Tab.create(null, c.calendarSettingsTab(),
				ContainerElement.create("editSharedMailboxCalendar", calendarsContent)));

		// todolists
		JsArray<ScreenElement> todolistsContet = JsArray.createArray().cast();
		todolistsContet.push(ScreenElement.create(null, UserTodolistsSharingsEditor.TYPE)
				.witTitle(c.todolistSharingsTab()).withRole(BasicRoles.ROLE_MANAGE_USER_SHARINGS));
		todolistsContet.push(ScreenElement.create(null, UserTodolistsSubscriptionsEditor.TYPE)
				.withRole(BasicRoles.ROLE_MANAGE_USER_SUBSCRIPTIONS));
		tabs.push(Tab.create(null, c.todolistSettingsTab(),
				ContainerElement.create("editSharedMailboxTodolist", todolistsContet)));

		// maintenance
		JsArray<ScreenElement> maintenanceContents = JsArray.createArray().cast();
		SharedMailboxCheckAndRepair.registerType();

		maintenanceContents.push(
				ScreenElement.create(null, ExternalIdEditor.TYPE).withRole(BasicRoles.ROLE_MANAGE_USER_EXTERNAL_ID));
		maintenanceContents.push(
				ScreenElement.create(null, SharedMailboxCheckAndRepair.TYPE).withRole(BasicRoles.ROLE_USER_CHECK_AND_REPAIR));

		maintenanceContents.push(
				ScreenElement.create(null, MailboxMaintenance.TYPE).withRole(BasicRoles.ROLE_USER_MAILBOX_MAINTENANCE));
		tabs.push(
				Tab.create(null, c.maintenanceTab(), ContainerElement.create("editMaintenance", maintenanceContents)));

		TabContainer tab = TabContainer.create("editSharedMailboxTabs", tabs);
		screenRoot.setContent(tab);
		return screenRoot;
	}

}
