/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.sharedmailbox;

import java.util.HashMap;

import com.google.gwt.core.shared.GWT;

import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.gwtconsoleapp.base.editor.CompositeElement;
import net.bluemind.gwtconsoleapp.base.editor.ModelHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenElement;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot.SizeHint;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtCompositeScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.ui.adminconsole.base.Actions;
import net.bluemind.ui.adminconsole.directory.BaseQCreateScreen;
import net.bluemind.ui.adminconsole.directory.sharedmailbox.l10n.SharedMailboxConstants;

public class QCreateSharedMailboxScreen extends BaseQCreateScreen {

	public static final String TYPE = "bm.ac.QCreateSharedMailboxScreen";

	protected QCreateSharedMailboxScreen(ScreenRoot jsScreenRoot) {
		super(jsScreenRoot);
		title.setInnerText(SharedMailboxConstants.INST.newSharedMailbox());
		icon.setStyleName("fa fa-2x fa-envelope-square");
	}

	public static void registerType() {
		GwtScreenRoot.registerComposite(TYPE, new IGwtDelegateFactory<IGwtCompositeScreenRoot, ScreenRoot>() {

			@Override
			public QCreateSharedMailboxScreen create(ScreenRoot instance) {
				return new QCreateSharedMailboxScreen(instance);
			}
		});
		GWT.log("bm.ac.QCreateSharedMailboxScreen registred");
	}

	@Override
	protected void doCancel() {
		Actions.get().showWithParams2("directory", null);
	}

	@Override
	protected void doEditCreated() {
		String sharedMailboxId = rootScreen.getModel().<JsMapStringJsObject> cast().getString("dirEntryId");
		String domainUid = rootScreen.getModel().<JsMapStringJsObject> cast().getString("domainUid");

		HashMap<String, String> params = new HashMap<>();
		params.put("entryUid", sharedMailboxId);
		params.put("domainUid", domainUid);

		Actions.get().showWithParams2("editSharedMailbox", params);
	}

	public static ScreenElement screenModel() {
		ScreenRoot screenRoot = ScreenRoot.create("qcSharedMailbox", TYPE).cast();
		screenRoot.setOverlay(true);
		screenRoot.setSizeHint(SizeHint.create(450, 500));
		screenRoot.getHandlers().push(ModelHandler.create(null, QCreateSharedMailboxModelHandler.TYPE).<ModelHandler> cast());
		screenRoot.setContent(ScreenElement.create(null, NewSharedMailbox.TYPE).<CompositeElement> cast());
		return screenRoot;
	}

}
