/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.dataprotect;

import static com.google.gwt.dom.client.BrowserEvents.CLICK;

import java.util.Comparator;
import java.util.List;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.BrowserEvents;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;

import net.bluemind.ui.adminconsole.dataprotect.l10n.DPTexts;
import net.bluemind.dataprotect.api.RestoreOperation;

public class ActionRestoreCell<T> extends AbstractCell<List<ActionHandler<T>>> {

	public ActionRestoreCell() {
		super(BrowserEvents.CLICK);
	}

	@Override
	public void render(com.google.gwt.cell.client.Cell.Context context, List<ActionHandler<T>> value,
			SafeHtmlBuilder sb) {
		sb.appendHtmlConstant("<a href=\"#\">" + DPTexts.INST.restore() + "</a>");
	}

	@Override
	public void onBrowserEvent(com.google.gwt.cell.client.Cell.Context context, Element parent,
			List<ActionHandler<T>> value, NativeEvent event, ValueUpdater<List<ActionHandler<T>>> valueUpdater) {
		super.onBrowserEvent(context, parent, value, event, valueUpdater);
		if (CLICK.equals(event.getType())) {
			event.preventDefault();
			boolean completeRestore = value.stream().anyMatch(s -> s.getRestoreOp().identifier.startsWith("complete.restore."));
			DPRestoreDialog dialog = new DPRestoreDialog(completeRestore);

			value.stream().sorted(Comparator.comparing(ActionHandler::getName))
				.forEach(s -> dialog.addRestorableOperation(s.getRestoreOp(), s.getCommand()));

			dialog.center();
		}
	}

}
