/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.service;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider.IServerSideServiceFactory;
import net.bluemind.tx.outbox.api.ITxOutbox;

public class TxOutboxServiceFactory implements IServerSideServiceFactory<ITxOutbox> {

	@Override
	public Class<ITxOutbox> factoryClass() {
		return ITxOutbox.class;
	}

	@Override
	public ITxOutbox instance(BmContext context, String... params) throws ServerFault {
		if (params.length != 5) {
			throw new ServerFault("required parameters: domainUid, owner, type, containerUid, dataLocation");
		}
		String dom = params[0];
		String owner = params[1];
		String type = params[2];
		String contUid = params[3];
		String dataLocation = params[4];
		BaseContainerDescriptor dumb = BaseContainerDescriptor.create(contUid, "name", owner, type, dom, false);
		return new TxOutboxService(context, dumb, DataLocation.of(dataLocation));
	}

}
