/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.repository;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class NoopOutboxRepository implements ITxOutboxRepository {

	public static final ITxOutboxRepository INST = new NoopOutboxRepository();

	@Override
	public FlushSeqHolder seqHolder() {
		return FlushSeqHolder.get(INST);
	}

	@Override
	public long forKafka(String tgtTopic, String partKey, byte[] key, byte[] value) throws SQLException {
		return 0;
	}

	@Override
	public List<Long> kafkaPending(int limit) throws SQLException {
		return Collections.emptyList();
	}

	@Override
	public KafkaPayload get(long id) throws SQLException {
		return null;
	}

	@Override
	public void deleteOffsets(List<Long> offsets) throws SQLException {
	}

}
