<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.todolist.api.ITodoList.
 */

class TodoListClient {

  protected $base;
  protected $sid;
  protected $containerUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param containerUid
   *
   */
  public function __construct($base, $sid , $containerUid) {
    $this->sid = $sid;
    $this->base = $base."/api/todolist/{containerUid}";
    $this->containerUid = $containerUid;
    $this->base = str_replace("{containerUid}", urlencode($containerUid), $this->base);
  }


  /*
   * @return
   */
  public function all() {
    $postUri = "";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function allUids() {
    $postUri = "/_all";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @return
   */
  public function changeset( $since  ) {
    $postUri = "/_changeset";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @return
   */
  public function changesetById( $since  ) {
    $postUri = "/_changesetById";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uids
   * @param destContainerUid
   * @return
   */
  public function copy( $uids ,  $destContainerUid  ) {
    $postUri = "/_copy/{destContainerUid}";
    $method = "POST";

    $postUri = str_replace("{destContainerUid}", urlencode($destContainerUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $uids;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function count( $arg0  ) {
    $postUri = "/_count";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param todo
   * @return
   */
  public function create( $uid ,  $todo  ) {
    $postUri = "/{uid}";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $todo;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @param arg1
   * @return
   */
  public function createById( $id ,  $arg1  ) {
    $postUri = "/id/{id}";
    $method = "PUT";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function delete_( $uid  ) {
    $postUri = "/{uid}";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function deleteById( $id  ) {
    $postUri = "/id/{id}";
    $method = "DELETE";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @param arg1
   * @return
   */
  public function filteredChangesetById( $since ,  $arg1  ) {
    $postUri = "/_filteredChangesetById";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getByIcsUid( $uid  ) {
    $postUri = "/_icsuid/{uid}";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getComplete( $uid  ) {
    $postUri = "/{uid}/complete";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function getCompleteById( $id  ) {
    $postUri = "/{id}/completeById";
    $method = "GET";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function getVersion() {
    $postUri = "/_version";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param arg1
   * @return
   */
  public function itemChangelog( $uid ,  $arg1  ) {
    $postUri = "/{uid}/_itemchangelog";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uids
   * @param destContainerUid
   * @return
   */
  public function move( $uids ,  $destContainerUid  ) {
    $postUri = "/_move/{destContainerUid}";
    $method = "POST";

    $postUri = str_replace("{destContainerUid}", urlencode($destContainerUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $uids;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @param bypassDeletedItems
   * @return
   */
  public function multipleDeleteById( $arg0 ,  $bypassDeletedItems  ) {
    $postUri = "/_multipleDelete";
    $method = "DELETE";


    $url = $this->base.$postUri;

    $queryParam = array(
      "bypassDeletedItems" => $bypassDeletedItems);

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uids
   * @return
   */
  public function multipleGet( $uids  ) {
    $postUri = "/_mget";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $uids;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function multipleGetById( $arg0  ) {
    $postUri = "/_mgetById";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param range
   * @return
   */
  public function multipleGetByRange( $range  ) {
    $postUri = "/_mget_range";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $range;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param from
   * @param size
   * @return
   */
  public function multipleGetWithOffset( $from ,  $size  ) {
    $postUri = "/_mget_offset";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "from" => $from,      "size" => $size);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function reset() {
    $postUri = "/_reset";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param query
   * @return
   */
  public function search( $query  ) {
    $postUri = "/_search";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $query;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function sortedIds( $arg0  ) {
    $postUri = "/_sorted";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function sortedUids( $arg0  ) {
    $postUri = "/_sorteduids";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @param changes
   * @return
   */
  public function sync( $since ,  $changes  ) {
    $postUri = "/_sync";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    $body = $changes;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param todo
   * @return
   */
  public function update( $uid ,  $todo  ) {
    $postUri = "/{uid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $todo;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @param arg1
   * @return
   */
  public function updateById( $id ,  $arg1  ) {
    $postUri = "/id/{id}";
    $method = "POST";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param changes
   * @return
   */
  public function updates( $changes  ) {
    $postUri = "/_mupdates";
    $method = "PUT";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $changes;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
