<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VTodo.
 */
class VTodo extends ICalendarElement {

  /*
   * @type BmDateTime
   */
  public $due;

  /*
   * @type Integer
   */
  public $percent;

  /*
   * @type BmDateTime
   */
  public $completed;

  /*
   * @type String
   */
  public $uid;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->due = null;
    $this->percent = null;
    $this->completed = null;
    $this->uid = "";
  }

  public function toMap() {
    $data = array(    
        "due" => empty($this->due) ? null : $this->due,    
        "percent" => empty($this->percent) ? null : $this->percent,    
        "completed" => empty($this->completed) ? null : $this->completed,    
        "uid" => empty($this->uid) ? null : $this->uid);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
