/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.todolist.api.ITodoLists.
 */

goog.provide('net.bluemind.todolist.api.TodoListsVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.todolist.api.ITodoLists API.
 * @param {string sessionId} sessionId
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.todolist.api.TodoListsVertxClient = function( sessionId ) {
  this.sessionId = sessionId;
  this.base = '/todolists';
};

goog.inherits(net.bluemind.todolist.api.TodoListsVertxClient, net.bluemind.api.VertxBlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsVertxClient.prototype.create = function( uid ,  descriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = descriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsVertxClient.prototype.search = function( query  ) {

  var postUri = "/_search";

  var params = {};



  var body = null;
  body = query;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

