/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.todolist.api.ITodoListsMgmt.
 */

goog.provide('net.bluemind.todolist.api.TodoListsMgmtClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.todolist.api.ITodoListsMgmt API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.todolist.api.TodoListsMgmtClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/mgmt/todolists';
};

goog.inherits(net.bluemind.todolist.api.TodoListsMgmtClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @param {boolean} isDefault
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsMgmtClient.prototype.create = function( containerUid ,  descriptor ,  isDefault  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(isDefault)) {
    url.getQueryData().add('isDefault', isDefault);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsMgmtClient.prototype.getComplete = function( containerUid  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsMgmtClient.prototype.reindex = function( containerUid  ) {

  var postUri = "/{containerUid}/_reindex";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindex_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsMgmtClient.prototype.reindexAll = function() {

  var postUri = "/_reindex";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reindexAll_" 
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} containerUid
 * @param {Object} descriptor
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListsMgmtClient.prototype.update = function( containerUid ,  descriptor  ) {

  var postUri = "/{containerUid}";

  postUri = postUri.replace("{containerUid}", goog.string.urlEncode(containerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + containerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = descriptor;
  return this.execute(cmd, body);
};

