/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.todolist.api.ITodoList.
 */

goog.provide('net.bluemind.todolist.api.TodoListClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.todolist.api.ITodoList API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} containerUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.todolist.api.TodoListClient = function(rpc, base , containerUid ) {
  goog.base(this, rpc, base);
  this.base += '/todolist/{containerUid}';
   this.containerUid_ = containerUid;
   this.base = this.base.replace('{containerUid}',goog.string.urlEncode(containerUid));
};

goog.inherits(net.bluemind.todolist.api.TodoListClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} containerUid
 * @private
 */
net.bluemind.todolist.api.TodoListClient.prototype.containerUid_;

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.all = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "all_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.allUids = function() {

  var postUri = "/_all";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "allUids_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.changeset = function( since  ) {

  var postUri = "/_changeset";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "changeset_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.changesetById = function( since  ) {

  var postUri = "/_changesetById";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "changesetById_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @param {string} destContainerUid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.copy = function( uids ,  destContainerUid  ) {

  var postUri = "/_copy/{destContainerUid}";

  postUri = postUri.replace("{destContainerUid}", goog.string.urlEncode(destContainerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "copy_" 
                                  + this.containerUid_
                                  + destContainerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.count = function( arg0  ) {

  var postUri = "/_count";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "count_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg0;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} todo
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.create = function( uid ,  todo  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = todo;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.createById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "createById_" 
                                  + this.containerUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = arg1;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.deleteById = function( id  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "deleteById_" 
                                  + this.containerUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.filteredChangesetById = function( since ,  arg1  ) {

  var postUri = "/_filteredChangesetById";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "filteredChangesetById_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg1;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.getByIcsUid = function( uid  ) {

  var postUri = "/_icsuid/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getByIcsUid_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.getComplete = function( uid  ) {

  var postUri = "/{uid}/complete";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getComplete_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.getCompleteById = function( id  ) {

  var postUri = "/{id}/completeById";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getCompleteById_" 
                                  + this.containerUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.getVersion = function() {

  var postUri = "/_version";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getVersion_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {number} arg1
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.itemChangelog = function( uid ,  arg1  ) {

  var postUri = "/{uid}/_itemchangelog";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "itemChangelog_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  body = arg1;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @param {string} destContainerUid
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.move = function( uids ,  destContainerUid  ) {

  var postUri = "/_move/{destContainerUid}";

  postUri = postUri.replace("{destContainerUid}", goog.string.urlEncode(destContainerUid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "move_" 
                                  + this.containerUid_
                                  + destContainerUid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @param {boolean} bypassDeletedItems
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.multipleDeleteById = function( arg0 ,  bypassDeletedItems  ) {

  var postUri = "/_multipleDelete";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(bypassDeletedItems)) {
    url.getQueryData().add('bypassDeletedItems', bypassDeletedItems);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "multipleDeleteById_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  body = arg0;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<string>} uids
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.multipleGet = function( uids  ) {

  var postUri = "/_mget";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "multipleGet_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = uids;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Array.<number>} arg0
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.multipleGetById = function( arg0  ) {

  var postUri = "/_mgetById";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "multipleGetById_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg0;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.reset = function() {

  var postUri = "/_reset";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "reset_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} query
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.search = function( query  ) {

  var postUri = "/_search";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "search_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = query;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.sortedIds = function( arg0  ) {

  var postUri = "/_sorted";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "sortedIds_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg0;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} arg0
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.sortedUids = function( arg0  ) {

  var postUri = "/_sorteduids";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "sortedUids_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg0;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} since
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.sync = function( since ,  changes  ) {

  var postUri = "/_sync";


  var url = new goog.Uri(this.base + postUri);
  if (goog.isDefAndNotNull(since)) {
    url.getQueryData().add('since', since);
  }

  var cmd = new relief.rpc.Command(null, null, 
                                  "sync_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = changes;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} todo
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.update = function( uid ,  todo  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.containerUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = todo;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {number} id
 * @param {Object} arg1
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.updateById = function( id ,  arg1  ) {

  var postUri = "/id/{id}";

  postUri = postUri.replace("{id}", goog.string.urlEncode(id));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "updateById_" 
                                  + this.containerUid_
                                  + id
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = arg1;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {Object} changes
 * @return {Object}
 */
net.bluemind.todolist.api.TodoListClient.prototype.updates = function( changes  ) {

  var postUri = "/_mupdates";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "updates_" 
                                  + this.containerUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = changes;
  return this.execute(cmd, body);
};

