package net.bluemind.tests.defaultdata;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.domain.api.Domain;
import net.bluemind.group.api.Member;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.api.Mailbox.Routing;
import net.bluemind.resource.api.ResourceReservationMode;
import net.bluemind.server.api.Server;
import net.bluemind.user.api.User;
import net.bluemind.utils.FileUtils;

public class PopulateHelper {

	private static final BasePopulateHelper impl = new BasePopulateHelper(PopulateHelper::sqlContext);

	private static BmContext sqlContext() {
		return ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();
	}

	static {
		FileUtils.delete(new File("/var/cache/bm-core/sessions"));
	}

	private PopulateHelper() {
	}

	public static final String FAKE_CYRUS_IP = "10.1.2.3";
	public static final String FAKE_CYRUS_IP_2 = "10.1.22.33";

	public static void addDomain(String domain) throws Exception {
		impl.addDomain(domain);
	}

	public static void addDomain(String domain, Routing adminRouting, String... aliases) throws Exception {
		impl.addDomain(domain, adminRouting, aliases);
	}

	public static void createDomain(String domain, String... aliases) throws Exception {
		impl.createDomain(domain, aliases);
	}

	public static void initGlobalVirt(Server... servers) throws Exception {
		impl.initGlobalVirt(servers);
	}

	public static void initGlobalVirt(boolean withCore, Server... servers) throws Exception {
		impl.initGlobalVirt(withCore, servers);
	}

	public static ItemValue<Domain> createTestDomain(String domainUid, Server... servers) throws Exception {
		return impl.createTestDomain(domainUid, servers);
	}

	public static ItemValue<Domain> createTestDomain(String domainUid, Domain domain, Server... servers)
			throws Exception {
		return impl.createTestDomain(domainUid, domain, servers);
	}

	public static void unAssignFakeCyrus(String domainUid) throws SQLException, IOException {
		impl.unAssignFakeCyrus(domainUid);
	}

	public static void domainAdmin(String domainUid, String userUid) throws Exception {
		impl.domainAdmin(domainUid, userUid);
	}

	/**
	 * <i>Note: we use {@link Server#ip} for {@link ItemValue#uid} and
	 * {@link ItemValue#displayName}.</i>
	 */
	public static void createServers(Server... servers) throws ServerFault {
		impl.createServers(servers);
	}

	public static void addGlobalVirt(DataSource pool) throws Exception {
		impl.addGlobalVirt(pool);
	}

	public static String addDomainAdmin(String login, String domain) throws ServerFault, IOException {
		return impl.addDomainAdmin(login, domain);
	}

	public static String addDomainAdmin(String login, String domain, Mailbox.Routing routing)
			throws ServerFault, IOException {
		return impl.addDomainAdmin(login, domain, routing);
	}

	public static String addAdmin0() throws ServerFault, IOException {
		return impl.addDomainAdmin("admin0_global.virt", "admin0", "global.virt", Routing.none);
	}

	public static String addUser(String login, String domain) throws ServerFault, IOException {
		return impl.addUser(login, domain);
	}

	public static String addSharedMailbox(String login, String domain, String... roles)
			throws ServerFault, IOException {
		return impl.addSharedMailbox(login, domain, roles);
	}

	public static String addUserWithRoles(String login, String domain, String... roles)
			throws ServerFault, IOException {
		return impl.addUserWithRoles(login, domain, roles);
	}

	public static String addUser(String login, String domain, Mailbox.Routing mailrouting, String... roles)
			throws ServerFault {
		return impl.addUser(login, domain, mailrouting, roles);
	}

	public static String addUser(String login, String password, String domain, Mailbox.Routing mailrouting,
			String... roles) throws ServerFault {
		return impl.addUser(login, password, domain, mailrouting, roles);
	}

	public static String addSimpleUser(String login, String domain, Mailbox.Routing mailrouting, String... roles)
			throws ServerFault {
		return impl.addSimpleUser(login, domain, mailrouting, roles);
	}

	public static String addVisioUser(String login, String domain, Routing mailrouting, String... roles) {
		return impl.addVisioUser(login, domain, mailrouting, roles);
	}

	public static String addUser(String domain, User user, String... roles) {
		return impl.addUser(domain, user, roles);
	}

	public static User getUser(String login, String domain, Mailbox.Routing mailrouting) {
		return impl.getUser(login, domain, mailrouting);
	}

	public static User getSharedMailbox(String login, String domain, Mailbox.Routing mailrouting) {
		return impl.getSharedMailbox(login, domain, mailrouting);
	}

	public static User getUser(String login, String password, String domain, Mailbox.Routing mailrouting) {
		return impl.getUser(login, password, domain, mailrouting);
	}

	public static String addExternalUser(String domain, String email, String name) {
		return impl.addExternalUser(domain, email, name);
	}

	public static void assign(DataSource pool, String serverUid, String tag, String domainUid)
			throws ServerFault, IOException {
		impl.assign(pool, serverUid, tag, domainUid);
	}

	public static void createDomainSettings(String domainUid, Map<String, String> domainSettings) throws ServerFault {
		impl.createDomainSettings(domainUid, domainSettings);
	}

	public static void addOrgUnit(String domainUid, String uid, String name, String parentUid) {
		impl.addOrgUnit(domainUid, uid, name, parentUid);
	}

	public static String addGroup(String domainUid, String uid, String name, List<Member> members) {
		return impl.addGroup(domainUid, uid, name, members);
	}

	public static String addGroup(String domainUid, String uid, String name, List<Member> members, boolean withEmail) {
		return impl.addGroup(domainUid, uid, name, members, withEmail);
	}

	public static String addResource(String name, String domainUid) {
		return PopulateHelper.addResource(name, domainUid, ResourceReservationMode.OWNER_MANAGED);
	}

	public static String addResource(String name, String domainUid, ResourceReservationMode mode) {
		return impl.addResource(name, domainUid, mode);
	}

}
