/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.tag.api.ITagUids.
 */

goog.provide('net.bluemind.tag.api.TagUidsClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.tag.api.ITagUids API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.tag.api.TagUidsClient = function(rpc, base ) {
  goog.base(this, rpc, base);
  this.base += '/tags/uids';
};

goog.inherits(net.bluemind.tag.api.TagUidsClient, net.bluemind.api.BlueMindClient)


/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.tag.api.TagUidsClient.prototype.getDefaultUserTags = function( uid  ) {

  var postUri = "/{uid}/_default_tags";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getDefaultUserTags_" 
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

