CREATE EXTENSION IF NOT EXISTS hstore WITH schema pg_catalog;

CREATE TABLE t_credentials (
  item_id		bigint REFERENCES t_container_item(id) ON DELETE CASCADE,
  id			text NOT NULL,
  type			text NOT NULL,
  label			text,
  created		bigint,
  secret		text,
  credential	text,
  PRIMARY KEY(item_id, id, type)
);

CREATE INDEX idx_credentials_item_id ON t_credentials(item_id);
CREATE INDEX idx_credentials_id ON t_credentials(item_id, id);
CREATE INDEX idx_credentials_type ON t_credentials(item_id, type);
