package net.bluemind.system.service.hot;

import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.eclipse.common.RunnableExtensionLoader;
import net.bluemind.system.api.hot.upgrade.IInternalHotUpgrade;
import net.bluemind.system.service.hot.internal.InternalHotUpgrade;

public class InternalHotUpgradeFactory
		implements ServerSideServiceProvider.IServerSideServiceFactory<IInternalHotUpgrade> {

	private static final Logger logger = LoggerFactory.getLogger(InternalHotUpgradeFactory.class);
	private final List<HotUpgradeOperation.Factory> factories;

	public InternalHotUpgradeFactory() {
		RunnableExtensionLoader<HotUpgradeOperation.Factory> epLoader = new RunnableExtensionLoader<>();
		factories = epLoader.loadExtensions("net.bluemind.system.upgraders.hot", "hotupgradeoperation",
				"hot-upgrade-operation-provider", "class");
	}

	@Override
	public Class<IInternalHotUpgrade> factoryClass() {
		return IInternalHotUpgrade.class;
	}

	@Override
	public IInternalHotUpgrade instance(BmContext context, String... params) {
		List<HotUpgradeOperation> operations = factories.stream().map(factory -> factory.create(context))
				.collect(Collectors.toList());
		if (logger.isInfoEnabled()) {
			logger.info("Loaded {} hotupgrades: {}", operations.size(),
					operations.stream().map(HotUpgradeOperation::name).collect(Collectors.joining(",")));
		}
		return new InternalHotUpgrade(context, operations);
	}

}