package net.bluemind.system.service.hot.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.hotupgrade.repository.IHotUpgradeTaskStore;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.service.hot.HotUpgradeExecutableOperation;

public class SequentialHotUpgradeTaskExecutor extends HotUpgradeTaskExecutorDbUpdate {

	public SequentialHotUpgradeTaskExecutor(String operationName, HotUpgradeExecutableOperation operation,
			IHotUpgradeTaskStore store) {
		super(operationName, operation, store);
	}

	@Override
	public CompletableFuture<List<HotUpgradeTask>> execute(List<HotUpgradeTask> tasks, IServerTaskMonitor monitor) {
		monitor.log("Starting execution of " + operationName);

		CompletableFuture<Void> currentFuture = CompletableFuture.completedFuture(null);

		for (HotUpgradeTask task : tasks) {
			currentFuture = currentFuture.thenCompose(v -> {
				return executeTask(task, monitor);
			});
		}

		return currentFuture.thenApply((v) -> {
			monitor.log("Finished execution of " + operationName);
			return tasks;
		});
	}

}
