package net.bluemind.system.service.hot.internal;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.hotupgrade.repository.IHotUpgradeTaskStore;
import net.bluemind.repository.provider.RepositoryProvider;
import net.bluemind.system.api.hot.upgrade.HotUpgradeProgress;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter;
import net.bluemind.system.api.hot.upgrade.IHotUpgrade;

public class HotUpgrade implements IHotUpgrade {
	protected final IHotUpgradeTaskStore store;

	protected static final Set<HotUpgradeTask> runningTasks = ConcurrentHashMap.newKeySet();

	public HotUpgrade(BmContext context) {
		this.store = RepositoryProvider.instance(IHotUpgradeTaskStore.class, context);
	}

	@Override
	public Set<HotUpgradeTask> running() {
		return runningTasks;
	}

	@Override
	public List<HotUpgradeTask> list(HotUpgradeTaskFilter filter) {
		try {
			return store.list(filter);
		} catch (SQLException e) {
			throw new ServerFault("Unable to list tasks with filter " + filter, e);
		}
	}

	@Override
	public List<HotUpgradeProgress> progress() {
		try {
			return store.progress();
		} catch (SQLException e) {
			throw new ServerFault("Unable to report hot upgrade tasks progress", e);
		}
	}

}
