package net.bluemind.system.service.hot.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import io.netty.util.concurrent.DefaultThreadFactory;
import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.core.utils.ExecutorShutdownFuture;
import net.bluemind.hotupgrade.repository.IHotUpgradeTaskStore;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.service.hot.HotUpgradeExecutableOperation;

public class ParallelHotUpgradeTaskExecutor extends HotUpgradeTaskExecutorDbUpdate {

	public ParallelHotUpgradeTaskExecutor(String operationName, HotUpgradeExecutableOperation operation,
			IHotUpgradeTaskStore store) {
		super(operationName, operation, store);
	}

	@Override
	public CompletableFuture<List<HotUpgradeTask>> execute(List<HotUpgradeTask> tasks, IServerTaskMonitor monitor) {
		monitor.begin(tasks.size(), "Starting " + operationName + " execution");

		ExecutorService executor = Executors.newFixedThreadPool(4, new DefaultThreadFactory("hotupgrade-executor"));
		tasks.forEach(task -> executor.submit(() -> executeTask(task, monitor).get()));

		return ExecutorShutdownFuture.create(executor).thenApply(t -> tasks);
	}

}
