/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.service.hot;

import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;

public class HotUpgradeTaskMonitor implements IServerTaskMonitor {

	private final IServerTaskMonitor delegate;
	private final HotUpgradeTask task;

	public HotUpgradeTaskMonitor(IServerTaskMonitor delegate, HotUpgradeTask task) {
		this.delegate = delegate;
		this.task = task;
	}

	@Override
	public IServerTaskMonitor subWork(double work) {
		return delegate.subWork(work);
	}

	@Override
	public IServerTaskMonitor subWork(String logPrefix, double work) {
		return delegate.subWork(logPrefix, work);
	}

	@Override
	public void begin(double totalWork, String log) {
		delegate.begin(totalWork, log);
	}

	@Override
	public void progress(double doneWork, String log) {
		delegate.progress(doneWork, log);
	}

	@Override
	public void end(boolean success, String log, String result) {
		delegate.end(success, log, result);
	}

	@Override
	public void log(String log) {
		delegate.log(log);
	}

	public void event(HotUpgradeStepEvent event) {
		task.events.add(event);
	}

}
