/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.system.api.Database;

public interface IUpgraderStore {

	void store(Upgrader value);

	boolean upgraderCompleted(String upgraderId, String server, Database database) throws SQLException;

	List<ComponentVersion> getComponentsVersion() throws SQLException;

	void updateComponentVersion(String component, String version) throws SQLException;

	boolean upgraderRegistered(String upgraderId, String server, Database database) throws SQLException;

	boolean needsMigration() throws SQLException;
}
