/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.repository;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;

public interface ISystemConfStore {

	public final long GLOBAL_ID = 2012_03_31;

	Map<String, String> get() throws SQLException;

	default Map<String, String> get30() throws SQLException {
		return Collections.emptyMap();
	}

	void update(Map<String, String> mutations) throws SQLException;

}
