package net.bluemind.system.persistence.hot;

import java.util.ArrayList;
import java.util.Date;

import com.google.common.base.Strings;

import net.bluemind.core.jdbc.Columns;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus;

public class HotUpgradeTaskColumns {

	private HotUpgradeTaskColumns() {
	}

	public static final Columns COLUMNS = Columns.create() //
			.col("operation") //
			.col("parameters", "jsonb")//
			.col("status", "enum_hot_upgrade_task_status")//
			.col("failure")//
			.col("created_at")//
			.col("updated_at")//
			.col("execution_mode", "enum_hot_upgrade_execution_mode")//
			.col("retry_count")//
			.col("retry_delay")//
			.col("report_failure")//
			.col("eventlog", "jsonb")//
			.col("mandatory") //
			.col("upgrader_id");

	public static HotUpgradeTaskStore.EntityPopulator<HotUpgradeTask> populator() {
		return (rs, index, value) -> {
			value.id = rs.getInt(index++);
			value.operation = rs.getString(index++);
			value.parameters = rs.getString(index++);
			value.status = HotUpgradeTaskStatus.valueOf(rs.getString(index++));
			value.failure = rs.getInt(index++);
			value.createdAt = Date.from(rs.getTimestamp(index++).toInstant());
			value.updatedAt = Date.from(rs.getTimestamp(index++).toInstant());
			value.executionMode = HotUpgradeTaskExecutionMode.valueOf(rs.getString(index++));
			value.retryCount = rs.getInt(index++);
			value.retryDelaySeconds = rs.getInt(index++);
			value.reportFailure = rs.getBoolean(index++);
			String eventString = rs.getString(index++);
			if (Strings.isNullOrEmpty(eventString)) {
				value.events = new ArrayList<>();
			} else {
				value.events = JsonUtils.listReader(HotUpgradeStepEvent.class).read(eventString);
			}
			value.mandatory = rs.getBoolean(index++);
			value.upgraderId = rs.getString(index++);
			return index;
		};

	}

}
