/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.ldap.importation.search;

import net.bluemind.core.api.Regex;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.system.importation.commons.Parameters;
import net.bluemind.system.ldap.importation.internal.tools.UserManagerImpl;

public class LdapUserSearchFilter extends LdapCommonSearchFilter {
	@Override
	protected String nameCondition(String name) {
		if (!Regex.LOGIN.validate(name)) {
			throw new ServerFault("Invalid user name " + name);
		}

		return "(" + UserManagerImpl.LDAP_LOGIN + "=" + name + ")";
	}

	@Override
	protected <T extends Parameters> String getFilter(T ldapParameters) {
		return ldapParameters.ldapDirectory.userFilter;
	}
}
