<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CertData.
 */
class CertData  {

  /*
   * @type CertDataCertificateDomainEngine
   */
  public $sslCertificateEngine;

  /*
   * @type String
   */
  public $certificateAuthority;

  /*
   * @type String
   */
  public $certificate;

  /*
   * @type String
   */
  public $privateKey;

  /*
   * @type String
   */
  public $domainUid;

  /*
   * @type String
   */
  public $email;

  /*
   * Constructor
   */
  public function __construct() {
    $this->certificateAuthority = "";
    $this->certificate = "";
    $this->privateKey = "";
    $this->domainUid = "";
    $this->email = "";
  }

  public function toMap() {
    $data = array(    
        "sslCertificateEngine" => empty($this->sslCertificateEngine) ? null : $this->sslCertificateEngine,    
        "certificateAuthority" => empty($this->certificateAuthority) ? null : $this->certificateAuthority,    
        "certificate" => empty($this->certificate) ? null : $this->certificate,    
        "privateKey" => empty($this->privateKey) ? null : $this->privateKey,    
        "domainUid" => empty($this->domainUid) ? null : $this->domainUid,    
        "email" => empty($this->email) ? null : $this->email);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
