<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Credential.
 */
class Credential  {

  /*
   * @type String
   */
  public $id;

  /*
   * @type String
   */
  public $type;

  /*
   * @type String
   */
  public $label;

  /*
   * @type long
   */
  public $created;

  /*
   * @type String
   */
  public $secret;

  /*
   * @type String
   */
  public $credential;

  /*
   * Constructor
   */
  public function __construct() {
    $this->id = "";
    $this->type = "";
    $this->label = "";
    $this->created = 0;
    $this->secret = "";
    $this->credential = "";
  }

  public function toMap() {
    $data = array(    
        "id" => empty($this->id) ? null : $this->id,    
        "type" => empty($this->type) ? null : $this->type,    
        "label" => empty($this->label) ? null : $this->label,    
        "created" => empty($this->created) ? null : $this->created,    
        "secret" => empty($this->secret) ? null : $this->secret,    
        "credential" => empty($this->credential) ? null : $this->credential);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
