<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DomainTemplateTag.
 */
class DomainTemplateTag  {

  /*
   * @type String
   */
  public $value;

  /*
   * @type DomainTemplateDescription
   */
  public $description;

  /*
   * @type boolean
   */
  public $multival;

  /*
   * @type boolean
   */
  public $mandatory;

  /*
   * @type boolean
   */
  public $autoAssign;

  /*
   * Constructor
   */
  public function __construct() {
    $this->value = "";
    $this->description =   new DomainTemplateDescription();
    $this->multival = false;
    $this->mandatory = false;
    $this->autoAssign = false;
  }

  public function toMap() {
    $data = array(    
        "value" => empty($this->value) ? null : $this->value,    
        "description" => empty($this->description) ? null : $this->description,    
        "multival" => empty($this->multival) ? null : $this->multival,    
        "mandatory" => empty($this->mandatory) ? null : $this->mandatory,    
        "autoAssign" => empty($this->autoAssign) ? null : $this->autoAssign);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
