<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CloneConfiguration.
 */
class CloneConfiguration  {

  /*
   * @type String
   */
  public $sourceInstallationId;

  /*
   * @type String
   */
  public $targetInstallationId;

  /*
   * @type Map
   */
  public $uidToIpMapping;

  /*
   * @type Map
   */
  public $sysconfOverride;

  /*
   * @type CloneConfigurationMode
   */
  public $mode;

  /*
   * @type int
   */
  public $cloneWorkers;

  /*
   * @type Set
   */
  public $skippedContainerTypes;

  /*
   * Constructor
   */
  public function __construct() {
    $this->sourceInstallationId = "";
    $this->targetInstallationId = "";
    $this->uidToIpMapping = array();
    $this->sysconfOverride = array();
    $this->cloneWorkers = 0;
    $this->skippedContainerTypes = array();
  }

  public function toMap() {
    $data = array(    
        "sourceInstallationId" => empty($this->sourceInstallationId) ? null : $this->sourceInstallationId,    
        "targetInstallationId" => empty($this->targetInstallationId) ? null : $this->targetInstallationId,    
        "uidToIpMapping" => empty($this->uidToIpMapping) ? null : $this->uidToIpMapping,    
        "sysconfOverride" => empty($this->sysconfOverride) ? null : $this->sysconfOverride,    
        "mode" => empty($this->mode) ? null : $this->mode,    
        "cloneWorkers" => empty($this->cloneWorkers) ? null : $this->cloneWorkers,    
        "skippedContainerTypes" => empty($this->skippedContainerTypes) ? null : $this->skippedContainerTypes);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
