/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.server.repository;

import java.sql.SQLException;
import java.util.List;

import net.bluemind.server.api.Assignment;

public interface IServerAssignmentStore {

	public void assign(final String serverUid, final String domainUid, final String tag) throws SQLException;

	public List<Assignment> getAssignments(final String domainUid) throws SQLException;

	public List<Assignment> getServerAssignments(final String uid) throws SQLException;

	public void pruneStaleAssignments() throws SQLException;

	public void unassign(final String serverUid, final String domainUid, final String tag) throws SQLException;

	public void unassignFromDomain(final String domainUid) throws SQLException;

}
