package net.bluemind.sds.sync.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdsSyncLock {
	private static final Logger logger = LoggerFactory.getLogger(SdsSyncLock.class);
	private static final Path LOCK_FILE = Path.of("/etc/bm/sdssync.locked");
	private static final SdsSyncLock INSTANCE = new SdsSyncLock();

	public static SdsSyncLock get() {
		return INSTANCE;
	}

	private boolean isLocked;

	private SdsSyncLock() {
		isLocked = Files.exists(LOCK_FILE);
	}

	public boolean isLocked() {
		return isLocked;
	}

	public void lock() {
		if (!Files.exists(LOCK_FILE)) {
			try {
				Files.createFile(LOCK_FILE);
			} catch (IOException e) {
				logger.error("Not able to create lock file", e);
			}
		}
		isLocked = true;
	}

	public void unlock() {
		try {
			Files.deleteIfExists(LOCK_FILE);
		} catch (IOException e) {
			logger.error("Not able to create lock file", e);
		}
		isLocked = false;
	}

}
